/*
 * Decompiled with CFR 0.152.
 */
package com.pam.pamhc2trees.worldgen;

import com.mojang.datafixers.Dynamic;
import com.pam.pamhc2trees.config.ChanceConfig;
import com.pam.pamhc2trees.config.DimensionConfig;
import com.pam.pamhc2trees.config.EnableConfig;
import com.pam.pamhc2trees.init.BlockRegistry;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class WarmFruitTreeFeature
extends Feature<NoFeatureConfig> {
    public WarmFruitTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos pos, NoFeatureConfig config) {
        if (random.nextInt((Integer)ChanceConfig.warmfruittree_chance.get()) != 0 || ((List)DimensionConfig.blacklist.get()).contains(world.func_201675_m().func_186058_p().func_186068_a()) || !((List)DimensionConfig.whitelist.get()).contains(world.func_201675_m().func_186058_p().func_186068_a())) {
            return false;
        }
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c().func_203417_a(BlockTags.field_219750_S) && world.func_180495_p(pos).func_185904_a().func_76222_j()) {
            int type = (int)(Math.random() * 9.0 + 1.0);
            WarmFruitTreeFeature.generateTree(world, pos, random, type);
            return true;
        }
        return false;
    }

    public static void generateTree(IWorld world, BlockPos pos, Random random, int verify) {
        BlockState trunk = WarmFruitTreeFeature.getTrunk(verify);
        BlockState leaves = WarmFruitTreeFeature.getLeaves(verify);
        BlockState fruit = WarmFruitTreeFeature.getFruit(verify, random);
        world.func_180501_a(pos.func_177981_b(0), trunk, 3);
        world.func_180501_a(pos.func_177981_b(1), trunk, 3);
        world.func_180501_a(pos.func_177981_b(2), trunk, 3);
        world.func_180501_a(pos.func_177981_b(3), trunk, 3);
        world.func_180501_a(pos.func_177981_b(4), trunk, 3);
        if (world.func_180495_p(pos.func_177981_b(3).func_177978_c().func_177978_c()).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(3).func_177978_c().func_177978_c(), fruit, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(3).func_177968_d().func_177968_d()).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(3).func_177968_d().func_177968_d(), fruit, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(3).func_177974_f().func_177974_f()).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(3).func_177974_f().func_177974_f(), fruit, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(3).func_177976_e().func_177976_e()).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(3).func_177976_e().func_177976_e(), fruit, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(4).func_177978_c()).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(4).func_177978_c(), fruit, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(4).func_177968_d()).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(4).func_177968_d(), fruit, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(4).func_177974_f()).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(4).func_177974_f(), fruit, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(4).func_177976_e()).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(4).func_177976_e(), fruit, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(4).func_177978_c().func_177978_c()).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(4).func_177978_c().func_177978_c(), leaves, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(4).func_177968_d().func_177968_d()).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(4).func_177968_d().func_177968_d(), leaves, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(4).func_177974_f().func_177974_f()).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(4).func_177974_f().func_177974_f(), leaves, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(4).func_177976_e().func_177976_e()).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(4).func_177976_e().func_177976_e(), leaves, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(5)).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(5), trunk, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(5).func_177978_c()).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(5).func_177978_c(), leaves, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(5).func_177978_c().func_177978_c()).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(5).func_177978_c().func_177978_c(), leaves, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(5).func_177978_c().func_177974_f()).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(5).func_177978_c().func_177974_f(), leaves, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(5).func_177978_c().func_177976_e()).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(5).func_177978_c().func_177976_e(), leaves, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(5).func_177968_d()).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(5).func_177968_d(), leaves, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(5).func_177968_d().func_177968_d()).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(5).func_177968_d().func_177968_d(), leaves, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(5).func_177968_d().func_177974_f()).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(5).func_177968_d().func_177974_f(), leaves, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(5).func_177968_d().func_177976_e()).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(5).func_177968_d().func_177976_e(), leaves, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(5).func_177974_f()).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(5).func_177974_f(), leaves, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(5).func_177974_f().func_177974_f()).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(5).func_177974_f().func_177974_f(), leaves, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(5).func_177976_e()).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(5).func_177976_e(), leaves, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(5).func_177976_e().func_177976_e()).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(5).func_177976_e().func_177976_e(), leaves, 3);
        }
        if (world.func_180495_p(pos.func_177981_b(6)).func_185904_a().func_76222_j()) {
            world.func_180501_a(pos.func_177981_b(6), leaves, 3);
        }
    }

    private static BlockState getLeaves(int verify) {
        return (BlockState)Blocks.field_196648_Z.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(1));
    }

    private static BlockState getTrunk(int verify) {
        return Blocks.field_196620_N.func_176223_P();
    }

    private static BlockState getFruit(int verify, Random random) {
        int i = random.nextInt(2);
        switch (verify) {
            case 1: {
                if (EnableConfig.almond_worldgen != null) {
                    return (BlockState)BlockRegistry.pamalmond.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 2: {
                if (EnableConfig.apricot_worldgen != null) {
                    return (BlockState)BlockRegistry.pamapricot.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 3: {
                if (EnableConfig.banana_worldgen != null) {
                    return (BlockState)BlockRegistry.pambanana.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 4: {
                if (EnableConfig.cashew_worldgen != null) {
                    return (BlockState)BlockRegistry.pamcashew.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 5: {
                if (EnableConfig.coconut_worldgen != null) {
                    return (BlockState)BlockRegistry.pamcoconut.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 6: {
                if (EnableConfig.date_worldgen != null) {
                    return (BlockState)BlockRegistry.pamdate.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 7: {
                if (EnableConfig.dragonfruit_worldgen != null) {
                    return (BlockState)BlockRegistry.pamdragonfruit.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 8: {
                if (EnableConfig.durian_worldgen != null) {
                    return (BlockState)BlockRegistry.pamdurian.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 9: {
                if (EnableConfig.fig_worldgen != null) {
                    return (BlockState)BlockRegistry.pamfig.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 10: {
                if (EnableConfig.grapefruit_worldgen != null) {
                    return (BlockState)BlockRegistry.pamgrapefruit.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 11: {
                if (EnableConfig.lime_worldgen != null) {
                    return (BlockState)BlockRegistry.pamlime.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 12: {
                if (EnableConfig.mango_worldgen != null) {
                    return (BlockState)BlockRegistry.pammango.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 13: {
                if (EnableConfig.olive_worldgen != null) {
                    return (BlockState)BlockRegistry.pamolive.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 14: {
                if (EnableConfig.papaya_worldgen != null) {
                    return (BlockState)BlockRegistry.pampapaya.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 15: {
                if (EnableConfig.pecan_worldgen != null) {
                    return (BlockState)BlockRegistry.pampecan.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 16: {
                if (EnableConfig.peppercorn_worldgen != null) {
                    return (BlockState)BlockRegistry.pampeppercorn.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 17: {
                if (EnableConfig.persimmon_worldgen != null) {
                    return (BlockState)BlockRegistry.pampersimmon.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 18: {
                if (EnableConfig.pistachio_worldgen != null) {
                    return (BlockState)BlockRegistry.pampistachio.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 19: {
                if (EnableConfig.pomegranate_worldgen != null) {
                    return (BlockState)BlockRegistry.pampomegranate.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 20: {
                if (EnableConfig.starfruit_worldgen != null) {
                    return (BlockState)BlockRegistry.pamstarfruit.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 21: {
                if (EnableConfig.vanillabean_worldgen != null) {
                    return (BlockState)BlockRegistry.pamvanillabean.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 22: {
                if (EnableConfig.breadfruit_worldgen != null) {
                    return (BlockState)BlockRegistry.pambreadfruit.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 23: {
                if (EnableConfig.guava_worldgen != null) {
                    return (BlockState)BlockRegistry.pamguava.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 24: {
                if (EnableConfig.jackfruit_worldgen != null) {
                    return (BlockState)BlockRegistry.pamjackfruit.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 25: {
                if (EnableConfig.lychee_worldgen != null) {
                    return (BlockState)BlockRegistry.pamlychee.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 26: {
                if (EnableConfig.passionfruit_worldgen != null) {
                    return (BlockState)BlockRegistry.pampassionfruit.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 27: {
                if (EnableConfig.rambutan_worldgen != null) {
                    return (BlockState)BlockRegistry.pamrambutan.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
                }
            }
            case 28: {
                if (EnableConfig.tamarind_worldgen == null) break;
                return (BlockState)BlockRegistry.pamtamarind.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
            }
        }
        return (BlockState)BlockRegistry.pamalmond.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(i));
    }
}

