/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui;

import logisticspipes.modules.ModuleActiveSupplier;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.module.SupplierPipeLimitedPacket;
import logisticspipes.network.packets.module.SupplierPipeModePacket;
import logisticspipes.network.packets.pipe.SlotFinderOpenGuiPacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.LogisticsBaseGuiScreen;
import logisticspipes.utils.gui.SmallGuiButton;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiSupplierPipe
extends LogisticsBaseGuiScreen {
    private static final String PREFIX = "gui.supplierpipe.";
    private ModuleActiveSupplier module;
    private final boolean hasPatternUpgrade;
    private static final ResourceLocation TEXTURE = new ResourceLocation("logisticspipes", "textures/gui/supplier.png");

    public GuiSupplierPipe(IInventory playerInventory, IInventory dummyInventory, ModuleActiveSupplier module, Boolean flag, int[] slots) {
        super(null);
        this.hasPatternUpgrade = flag;
        DummyContainer dummy = new DummyContainer(playerInventory, dummyInventory);
        dummy.addNormalSlotsForPlayerInventory(18, 97);
        if (this.hasPatternUpgrade) {
            for (int i = 0; i < 9; ++i) {
                dummy.addDummySlot(i, 18 + i * 18, 20);
            }
        } else {
            int xOffset = 72;
            int yOffset = 18;
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 3; ++column) {
                    dummy.addDummySlot(column + row * 3, xOffset + column * 18, yOffset + row * 18);
                }
            }
        }
        this.field_147002_h = dummy;
        module.slotArray = slots;
        this.module = module;
        this.field_146999_f = 194;
        this.field_147000_g = 186;
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        String name = "";
        name = this.hasPatternUpgrade ? StringUtils.translate("gui.supplierpipe.TargetInvPattern") : StringUtils.translate("gui.supplierpipe.TargetInv");
        this.field_146297_k.field_71466_p.func_78276_b(name, this.field_146999_f / 2 - this.field_146297_k.field_71466_p.func_78256_a(name) / 2, 6, 0x404040);
        this.field_146297_k.field_71466_p.func_78276_b(StringUtils.translate("gui.supplierpipe.Inventory"), 18, this.field_147000_g - 102, 0x404040);
        this.field_146297_k.field_71466_p.func_78276_b(StringUtils.translate("gui.supplierpipe.RequestMode"), this.field_146999_f - 140, this.field_147000_g - 112, 0x404040);
        if (this.hasPatternUpgrade) {
            for (int i = 0; i < 9; ++i) {
                this.field_146297_k.field_71466_p.func_78276_b(Integer.toString(this.module.slotArray[i]), 22 + i * 18, 55, 0x404040);
            }
        }
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        if (!this.hasPatternUpgrade) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
            int j = this.field_147003_i;
            int k = this.field_147009_r;
            this.func_73729_b(j, k, 0, 0, this.field_146999_f, this.field_147000_g);
        } else {
            GuiGraphics.drawGuiBackGround(this.field_146297_k, this.field_147003_i, this.field_147009_r, this.right, this.bottom, this.field_73735_i, true);
            GL11.glTranslated((double)this.field_147003_i, (double)this.field_147009_r, (double)0.0);
            for (int i = 0; i < 9; ++i) {
                GuiGraphics.drawSlotBackground(this.field_146297_k, 17 + i * 18, 19);
                Slot slot = this.field_147002_h.func_75139_a(36 + i);
                if (slot == null || !slot.func_75216_d() || slot.func_75211_c().field_77994_a <= 64) continue;
                this.drawRect(18 + i * 18, 20, 34 + i * 18, 36, Color.RED);
            }
            GuiGraphics.drawPlayerInventoryBackground(this.field_146297_k, 18, 97);
            GL11.glTranslated((double)(-this.field_147003_i), (double)(-this.field_147009_r), (double)0.0);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 + 35, this.field_146295_m / 2 - 25, 50, 20, (this.hasPatternUpgrade ? this.module.getPatternMode() : this.module.getSupplyMode()).toString()));
        if (this.hasPatternUpgrade) {
            this.field_146292_n.add(new SmallGuiButton(1, this.field_147003_i + 5, this.field_147009_r + 68, 45, 10, this.module.isLimited() ? "Limited" : "Unlimited"));
            for (int i = 0; i < 9; ++i) {
                this.field_146292_n.add(new SmallGuiButton(i + 2, this.field_147003_i + 18 + i * 18, this.field_147009_r + 40, 17, 10, "Set"));
            }
        }
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton.field_146127_k == 0) {
            if (this.hasPatternUpgrade) {
                int currentMode = this.module.getPatternMode().ordinal() + 1;
                if (currentMode >= ModuleActiveSupplier.PatternMode.values().length) {
                    currentMode = 0;
                }
                this.module.setPatternMode(ModuleActiveSupplier.PatternMode.values()[currentMode]);
                ((GuiButton)this.field_146292_n.get((int)0)).field_146126_j = this.module.getPatternMode().toString();
            } else {
                int currentMode = this.module.getSupplyMode().ordinal() + 1;
                if (currentMode >= ModuleActiveSupplier.SupplyMode.values().length) {
                    currentMode = 0;
                }
                this.module.setSupplyMode(ModuleActiveSupplier.SupplyMode.values()[currentMode]);
                ((GuiButton)this.field_146292_n.get((int)0)).field_146126_j = this.module.getSupplyMode().toString();
            }
            MainProxy.sendPacketToServer(PacketHandler.getPacket(SupplierPipeModePacket.class).setModulePos(this.module));
        } else if (this.hasPatternUpgrade) {
            if (guibutton.field_146127_k == 1) {
                this.module.setLimited(!this.module.isLimited());
                ((GuiButton)this.field_146292_n.get((int)1)).field_146126_j = this.module.isLimited() ? "Limited" : "Unlimited";
                MainProxy.sendPacketToServer(PacketHandler.getPacket(SupplierPipeLimitedPacket.class).setLimited(this.module.isLimited()).setModulePos(this.module));
            } else if (guibutton.field_146127_k >= 2 && guibutton.field_146127_k <= 10) {
                MainProxy.sendPacketToServer(PacketHandler.getPacket(SlotFinderOpenGuiPacket.class).setSlot(guibutton.field_146127_k - 2).setModulePos(this.module));
            }
        }
        super.func_146284_a(guibutton);
    }

    public void refreshMode() {
        ((GuiButton)this.field_146292_n.get((int)0)).field_146126_j = (this.hasPatternUpgrade ? this.module.getPatternMode() : this.module.getSupplyMode()).toString();
        if (this.hasPatternUpgrade) {
            ((GuiButton)this.field_146292_n.get((int)1)).field_146126_j = this.module.isLimited() ? "Limited" : "Unlimited";
        }
    }
}

