/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.workbench;

import cofh.core.render.IconRegistry;
import cofh.core.util.CoreUtils;
import cofh.core.util.crafting.RecipeUpgrade;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.BlockTEBase;
import cofh.thermalexpansion.block.TileInventory;
import cofh.thermalexpansion.block.strongbox.BlockStrongbox;
import cofh.thermalexpansion.block.workbench.TileWorkbench;
import cofh.thermalexpansion.block.workbench.TileWorkbenchCreative;
import cofh.thermalexpansion.util.crafting.TECraftingHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockWorkbench
extends BlockTEBase {
    public static final String[] NAMES = new String[]{"creative", "basic", "hardened", "reinforced", "resonant"};
    public static final float[] HARDNESS = new float[]{-1.0f, 5.0f, 15.0f, 20.0f, 20.0f};
    public static final int[] RESISTANCE = new int[]{1200, 15, 90, 120, 120};
    public static boolean[] enable = new boolean[Types.values().length];
    public static ItemStack workbenchCreative;
    public static ItemStack workbenchBasic;
    public static ItemStack workbenchHardened;
    public static ItemStack workbenchReinforced;
    public static ItemStack workbenchResonant;

    public BlockWorkbench() {
        super(Material.field_151573_f);
        this.func_149711_c(15.0f);
        this.func_149752_b(25.0f);
        this.func_149663_c("thermalexpansion.workbench");
    }

    public TileEntity func_149915_a(World world, int n) {
        if (n >= Types.values().length) {
            return null;
        }
        if (n == Types.CREATIVE.ordinal()) {
            if (!enable[Types.CREATIVE.ordinal()]) {
                return null;
            }
            return new TileWorkbenchCreative(n);
        }
        return new TileWorkbench(n);
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        if (enable[0]) {
            list.add(new ItemStack(item, 1, 0));
        }
        for (int i = 1; i < Types.values().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @Override
    public void func_149689_a(World world, int n, int n2, int n3, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        if (world.func_72805_g(n, n2, n3) == 0 && !enable[0]) {
            world.func_147468_f(n, n2, n3);
            return;
        }
        if (itemStack.field_77990_d != null) {
            TileWorkbench tileWorkbench = (TileWorkbench)world.func_147438_o(n, n2, n3);
            if (itemStack.field_77990_d.func_74764_b("Inventory")) {
                tileWorkbench.readInventoryFromNBT(itemStack.field_77990_d);
            }
        }
        super.func_149689_a(world, n, n2, n3, entityLivingBase, itemStack);
    }

    public float func_149712_f(World world, int n, int n2, int n3) {
        return HARDNESS[world.func_72805_g(n, n2, n3)];
    }

    public float getExplosionResistance(Entity entity, World world, int n, int n2, int n3, double d, double d2, double d3) {
        return RESISTANCE[world.func_72805_g(n, n2, n3)];
    }

    public boolean isNormalCube(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return false;
    }

    public boolean func_149662_c() {
        return true;
    }

    public boolean isSideSolid(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return true;
    }

    public boolean func_149686_d() {
        return true;
    }

    @Override
    public IIcon func_149691_a(int n, int n2) {
        if (n == 0) {
            return IconRegistry.getIcon((String)"WorkbenchBottom", (int)n2);
        }
        if (n == 1) {
            return IconRegistry.getIcon((String)"WorkbenchTop", (int)n2);
        }
        return IconRegistry.getIcon((String)"WorkbenchSide", (int)n2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        for (int i = 0; i < Types.values().length; ++i) {
            IconRegistry.addIcon((String)("WorkbenchBottom" + i), (String)("thermalexpansion:workbench/Workbench_" + StringHelper.titleCase((String)NAMES[i]) + "_Bottom"), (IIconRegister)iIconRegister);
            IconRegistry.addIcon((String)("WorkbenchTop" + i), (String)("thermalexpansion:workbench/Workbench_" + StringHelper.titleCase((String)NAMES[i]) + "_Top"), (IIconRegister)iIconRegister);
            IconRegistry.addIcon((String)("WorkbenchSide" + i), (String)("thermalexpansion:workbench/Workbench_" + StringHelper.titleCase((String)NAMES[i]) + "_Side"), (IIconRegister)iIconRegister);
        }
    }

    @Override
    public NBTTagCompound getItemStackTag(World world, int n, int n2, int n3) {
        NBTTagCompound nBTTagCompound = super.getItemStackTag(world, n, n2, n3);
        TileWorkbench tileWorkbench = (TileWorkbench)world.func_147438_o(n, n2, n3);
        if (tileWorkbench != null) {
            if (nBTTagCompound == null) {
                nBTTagCompound = new NBTTagCompound();
            }
            nBTTagCompound.func_74774_a("Mode", (byte)tileWorkbench.selectedSchematic);
            tileWorkbench.writeInventoryToNBT(nBTTagCompound);
        }
        return nBTTagCompound;
    }

    public ArrayList<ItemStack> dismantleBlock(EntityPlayer entityPlayer, World world, int n, int n2, int n3, boolean bl) {
        NBTTagCompound nBTTagCompound = this.getItemStackTag(world, n, n2, n3);
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileInventory) {
            ((TileInventory)tileEntity).inventory = new ItemStack[((TileInventory)tileEntity).inventory.length];
        }
        return super.dismantleBlock(entityPlayer, nBTTagCompound, world, n, n2, n3, bl, false);
    }

    public boolean canDismantle(EntityPlayer entityPlayer, World world, int n, int n2, int n3) {
        if (world.func_72805_g(n, n2, n3) == Types.CREATIVE.ordinal() && !CoreUtils.isOp((EntityPlayer)entityPlayer)) {
            return false;
        }
        return super.canDismantle(entityPlayer, world, n, n2, n3);
    }

    public boolean initialize() {
        TileWorkbench.initialize();
        TileWorkbenchCreative.initialize();
        workbenchCreative = new ItemStack((Block)this, 1, Types.CREATIVE.ordinal());
        workbenchBasic = new ItemStack((Block)this, 1, Types.BASIC.ordinal());
        workbenchHardened = new ItemStack((Block)this, 1, Types.HARDENED.ordinal());
        workbenchReinforced = new ItemStack((Block)this, 1, Types.REINFORCED.ordinal());
        workbenchResonant = new ItemStack((Block)this, 1, Types.RESONANT.ordinal());
        GameRegistry.registerCustomItemStack((String)"workbenchCreative", (ItemStack)workbenchCreative);
        GameRegistry.registerCustomItemStack((String)"workbenchBasic", (ItemStack)workbenchBasic);
        GameRegistry.registerCustomItemStack((String)"workbenchHardened", (ItemStack)workbenchHardened);
        GameRegistry.registerCustomItemStack((String)"workbenchReinforced", (ItemStack)workbenchReinforced);
        GameRegistry.registerCustomItemStack((String)"workbenchResonant", (ItemStack)workbenchResonant);
        return true;
    }

    public boolean postInit() {
        if (enable[Types.BASIC.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeUpgrade(7, workbenchBasic, new Object[]{" X ", "ICI", " P ", Character.valueOf('C'), Blocks.field_150462_ai, Character.valueOf('I'), "ingotCopper", Character.valueOf('P'), BlockStrongbox.strongboxBasic, Character.valueOf('X'), Items.field_151121_aF}));
            GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)workbenchBasic, (Object[])new Object[]{"YXY", "ICI", "YPY", Character.valueOf('C'), Blocks.field_150462_ai, Character.valueOf('I'), "ingotCopper", Character.valueOf('P'), Blocks.field_150486_ae, Character.valueOf('X'), Items.field_151121_aF, Character.valueOf('Y'), "ingotTin"}));
        }
        if (enable[Types.HARDENED.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeUpgrade(workbenchHardened, new Object[]{" I ", "IXI", " I ", Character.valueOf('I'), "ingotInvar", Character.valueOf('X'), workbenchBasic}));
            GameRegistry.addRecipe((IRecipe)new RecipeUpgrade(7, workbenchHardened, new Object[]{"IPI", "CTC", "IBI", Character.valueOf('T'), Blocks.field_150462_ai, Character.valueOf('C'), "ingotCopper", Character.valueOf('B'), BlockStrongbox.strongboxBasic, Character.valueOf('P'), Items.field_151121_aF, Character.valueOf('I'), "ingotInvar"}));
        }
        if (enable[Types.REINFORCED.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeUpgrade(workbenchReinforced, new Object[]{" I ", "IXI", " I ", Character.valueOf('I'), "ingotSignalum", Character.valueOf('X'), workbenchHardened}));
        }
        if (enable[Types.RESONANT.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeUpgrade(workbenchResonant, new Object[]{" I ", "IXI", " I ", Character.valueOf('I'), "ingotEnderium", Character.valueOf('X'), workbenchReinforced}));
        }
        TECraftingHandler.addSecureRecipe(workbenchCreative);
        TECraftingHandler.addSecureRecipe(workbenchBasic);
        TECraftingHandler.addSecureRecipe(workbenchHardened);
        TECraftingHandler.addSecureRecipe(workbenchReinforced);
        TECraftingHandler.addSecureRecipe(workbenchResonant);
        return true;
    }

    static {
        String string = "Workbench.";
        BlockWorkbench.enable[0] = ThermalExpansion.config.get(string + StringHelper.titleCase((String)NAMES[0]), "Enable", true);
        for (int i = 1; i < Types.values().length; ++i) {
            BlockWorkbench.enable[i] = ThermalExpansion.config.get(string + StringHelper.titleCase((String)NAMES[i]), "Recipe.Enable", true);
        }
    }

    public static enum Types {
        CREATIVE,
        BASIC,
        HARDENED,
        REINFORCED,
        RESONANT;

    }
}

