/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.core.CoFHProps;
import cofh.core.render.IconRegistry;
import cofh.lib.render.RenderHelper;
import cofh.lib.util.helpers.FluidHelper;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.core.TEProps;
import cofh.thermalexpansion.gui.client.device.GuiNullifier;
import cofh.thermalexpansion.gui.container.device.ContainerNullifier;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileNullifier
extends TileDeviceBase
implements IFluidHandler {
    protected static final int[] SLOTS = new int[]{0};
    protected static final Fluid renderFluid = FluidRegistry.LAVA;

    public static void initialize() {
        int n = BlockDevice.Types.NULLIFIER.ordinal();
        TileDeviceBase.defaultSideConfig[n] = new TileTEBase.SideConfig();
        TileDeviceBase.defaultSideConfig[n].numConfig = 2;
        TileDeviceBase.defaultSideConfig[n].slotGroups = new int[][]{new int[0], {0}, new int[0]};
        TileDeviceBase.defaultSideConfig[n].allowInsertionSide = new boolean[]{false, false, false};
        TileDeviceBase.defaultSideConfig[n].allowExtractionSide = new boolean[]{false, false, false};
        TileDeviceBase.defaultSideConfig[n].allowInsertionSlot = new boolean[]{true};
        TileDeviceBase.defaultSideConfig[n].allowExtractionSlot = new boolean[]{false};
        TileDeviceBase.defaultSideConfig[n].sideTex = new int[]{0, 1, 4};
        TileDeviceBase.defaultSideConfig[n].defaultSides = new byte[]{0, 0, 0, 0, 0, 0};
        GameRegistry.registerTileEntity(TileNullifier.class, (String)"thermalexpansion.Nullifier");
    }

    public TileNullifier() {
        super(BlockDevice.Types.NULLIFIER);
        this.inventory = new ItemStack[1];
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public void setDefaultSides() {
        this.sideCache = this.getDefaultSides();
        this.sideCache[this.facing] = 1;
    }

    public int getLightValue() {
        return FluidHelper.getFluidLuminosity((Fluid)renderFluid);
    }

    @Override
    public boolean sendRedstoneUpdates() {
        return true;
    }

    protected boolean isSideAccessible(int n) {
        return this.sideCache[n] == 1 && this.redstoneControlOrDisable();
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiNullifier(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerNullifier(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public void readInventoryFromNBT(NBTTagCompound nBTTagCompound) {
    }

    @Override
    public void writeInventoryToNBT(NBTTagCompound nBTTagCompound) {
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return this.isSideAccessible(forgeDirection.ordinal()) ? fluidStack.amount : 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return null;
    }

    @Override
    public ItemStack func_70301_a(int n) {
        return this.inventory[n];
    }

    @Override
    public ItemStack func_70298_a(int n, int n2) {
        if (this.inventory[n] == null) {
            return null;
        }
        if (this.inventory[n].field_77994_a <= n2) {
            n2 = this.inventory[n].field_77994_a;
        }
        ItemStack itemStack = this.inventory[n].func_77979_a(n2);
        if (this.inventory[n].field_77994_a <= 0) {
            this.inventory[n] = null;
        }
        return itemStack;
    }

    @Override
    public ItemStack func_70304_b(int n) {
        if (this.inventory[n] == null) {
            return null;
        }
        ItemStack itemStack = this.inventory[n];
        this.inventory[n] = null;
        return itemStack;
    }

    @Override
    public void func_70299_a(int n, ItemStack itemStack) {
        if (n == 0) {
            return;
        }
        this.inventory[n] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    @Override
    public boolean setFacing(int n) {
        if (n < 0 || n > 5) {
            return false;
        }
        this.facing = (byte)n;
        this.sideCache[this.facing] = 1;
        this.func_70296_d();
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    @Override
    public IIcon getTexture(int n, int n2) {
        if (n2 == 0) {
            return n != this.facing ? BlockDevice.deviceSide : (this.redstoneControlOrDisable() ? RenderHelper.getFluidTexture((Fluid)renderFluid) : BlockDevice.deviceFace[this.type]);
        }
        if (n < 6) {
            return n != this.facing ? IconRegistry.getIcon((String)TEProps.textureSelection, (int)this.sideConfig.sideTex[this.sideCache[n]]) : (this.redstoneControlOrDisable() ? BlockDevice.deviceActive[this.type] : BlockDevice.deviceFace[this.type]);
        }
        return BlockDevice.deviceSide;
    }

    @Override
    public int[] func_94128_d(int n) {
        return this.isSideAccessible(n) ? SLOTS : CoFHProps.EMPTY_INVENTORY;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return this.isSideAccessible(n2);
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return false;
    }
}

